package com.ejie.aa94a.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

import com.ejie.aa94a.constantes.Constantes;

/**
 * Utilidades
 * 
 * @author GFI
 * 
 */
public class Utilidades {

	/**
	 * Constructor de Utilidades
	 */
	private Utilidades() {
	}

	/**
	 * Convierte un valor decimal a su representacion en String
	 * 
	 * @param number
	 *            BigDecimal decimal que se quiere formatear
	 * @param numDecimales
	 *            int maximo numero de decimales
	 * @return String cadena que representa el decimal
	 * @throws IllegalArgumentException
	 *             si no puede formatear el numero
	 */
	public static String format(BigDecimal number, int numDecimales)
			throws IllegalArgumentException {
		if (number == null) {
			return null;
		}
		DecimalFormat df = new DecimalFormat("#,##0.00",
				new DecimalFormatSymbols(Constantes.LOCALE_ES));
		df.setMinimumFractionDigits(numDecimales);
		df.setMaximumFractionDigits(numDecimales);
		return df.format(number);
	}
}